
exec(open('vehicleset.py').read())
from scipy.special import comb
class Zone:
        
    def __init__(self,zid,zname):
        self.zid=zid
        self.zname=zname
        
        self.demandpattern=None
        self._NFD={}
        
        self.routes={}
        self._intdistmatrix={}
        self._neighbours = []
     
        self._boundcap={}
        
        self._demandout={} #Outbound demand to all neighbours (current time step)
        self._demandin=0 #Sum of inbound demand from all neighbours (current time step)
        
        self._outflow_t=[] #Outbound flow (idx=time)
        self._inflow_t=[] #Inbound (idx=time)
        
        self._demandout_t=[] #Sum of outbound demand to all neighbours (idx=time)
        
        self._Kcum_t=[] #Cumulative accumulation (idx=time)
        self._dcum_t=[] #Cumulative distance travelled
        
        self._K_t=[] #Accumulation (idx=time)
        self._VT_t=[] #Through speed (idx=time)
        self._VL_t=[] #Local speed (idx=time)
        
        self._V=[] #Speed (debug variable)
        
        self._t=[]
        
        self._queue=[]
        self._pending=[]
        self._finished=[]
 
    def addNeighbours(self,nid_list,*args):
        if not type(nid_list) is list:
            nid_list=[nid_list]
        nid_list=nid_list+list(args)

        for nid in nid_list:
            self._neighbours.append(nid)
        
    def setdistmatrix(self,distmatrix):
        if not (comb(len(self._neighbours),2)+len(self._neighbours)+1 == len(distmatrix.keys())): raise Exception("Invalid dimensions for Distancematrix")
        
        self._intdistmatrix={}
        for key,val in distmatrix.items():
            self._intdistmatrix[key]=val

            if not key[0]==key[1]:
                self._intdistmatrix[(key[1],key[0])]=val
                
    def setboundcap(self,boundcap,dt):
        if not set(boundcap.keys())==set(self._neighbours): raise Exception("Invalid boundary capacity matrix")
        
        self._boundcap={}
        for key,val in boundcap.items():
            self._boundcap[key]=val*dt/3600

    def setNFD(self,NFD):
        try:
            self._NFD={
                'vf':NFD['vf'],
                'Pmax':NFD['C'],
                'K1':NFD['K1'],
                'K2':NFD['K2'],
                'K3':NFD['K3'],
                'Kj':NFD['Kj'],
                'Ltrip':NFD['Ltrip'],
                'Lnetwork':NFD['Lnetwork'],
                'vT':NFD['vT'],
                'CT':NFD['CT'],
                'K1T':NFD['K1T'],
                'K2T':NFD['K2T'],
                'K3T':NFD['K3T'],
                'KjT':NFD['KjT'],
                'vL':NFD['vL'],
                'CL':NFD['CL'],
                'K1L':NFD['K1L'],
                'K2L':NFD['K2L'],
                'K3L':NFD['K3L'],
                'KjL':NFD['KjL']
            }
            
            #self._NFD['Pmax']=self._NFD['K1']*self._NFD['vf'] #Capacity
            self._NFD['w']=-self._NFD['Pmax']/(self._NFD['Kj']-self._NFD['K3']) #Jam wave speed
            self._NFD['Pmin']=0.05*self._NFD['Pmax'] #To prevent gridlock set a minimum production
            
            ## THROUGH TRAFFIC ##
            self._NFD['wT']=-self._NFD['CT']/(self._NFD['KjT']-self._NFD['K3T']) #Jam wave speed
            self._NFD['PminT']=0.05*self._NFD['CT'] #To prevent gridlock set a minimum production
            self._NFD['CTt']=self._NFD['CT'] # Temporary capacity to cope with hysteresis
            self._NFD['PminTt']=0.5*self._NFD['CT'] #Set restriction to temporary capacity
            self._NFD['K1Tt']=self._NFD['K1T'] # Temporary restriction to cope with hysteresis
            self._NFD['K2Tt']=self._NFD['K2T'] # Temporary restriction to cope with hysteresis
            
            ## LOCAL TRAFFIC ##
            self._NFD['wL']=-self._NFD['CL']/(self._NFD['KjL']-self._NFD['K3L']) #Jam wave speed
            self._NFD['PminL']=0.05*self._NFD['CL'] #To prevent gridlock set a minimum production
            
        except:
            raise Exception("Invalid NFD input")
                  
    #def gendemand(self,OD,dt):
    #    demand_sq=[sum(self.demandpattern[x:x+dt]) for x in range(0,86400,dt)]
    #    for zid in OD.keys():
    #        self._specdemand[zid]=[OD[zid]*x for x in demand_sq]
    
    def nextstep(self,dt):
        ## Update time (seconds) ##
        if len(self._t)>0:
            self._t.append(self._t[-1]+dt) 
        else:
            self._t.append(0)
        
        ## Create new item in accumularion list ##
        if len(self._K_t)>0:
            self._K_t.append(self._K_t[-1])
        else:
            self._K_t.append(0)
            
            
        if self._K_t[-1]>400000:
            raise Exception('Accumulation exceeded >400,000 veh')
            
        ## Create new item in cumulative accumularion list ##
        if len(self._Kcum_t)>0:
            self._Kcum_t.append(self._Kcum_t[-1])
        else:
            self._Kcum_t.append(0)  
            
        ## Create new item in cumulative distance list ##
        if len(self._dcum_t)>0:
            self._dcum_t.append(self._dcum_t[-1])
        else:
            self._dcum_t.append(0)
        
        ## Create new item in exit and inflow list ##
        self._outflow_t.append(0)
        self._inflow_t.append(0)
        self._demandout_t.append(0)
        
        ## Calculate average density ##
        K=self._K_t[-1]/self._NFD['Lnetwork']
        
        ## Update NFD parameters (hysteresis) ##
        if K>self._NFD['K3T']:
            self._NFD['CTt']=max(min(self._NFD['CTt'],max((K-self._NFD['KjT'])*self._NFD['wT'],self._NFD['PminT'])),self._NFD['PminTt'])
            if self._NFD['CTt'] > self._NFD['K1Tt']*self._NFD['vT']:
                self._NFD['K2Tt']=self._NFD['K1Tt']+(self._NFD['CTt']-self._NFD['K1Tt']*self._NFD['vT'])/(self._NFD['CT']-self._NFD['K1Tt']*self._NFD['vT'])*(self._NFD['K2Tt']-self._NFD['K1Tt'])
            else:
                self._NFD['K1Tt']=self._NFD['CTt']/self._NFD['vT']
                self._NFD['K2Tt']=self._NFD['K1Tt']
            
        elif K<=self._NFD['K2Tt']:
            self._NFD['CTt']=self._NFD['CT']
            self._NFD['K1Tt']=self._NFD['K1T']
            self._NFD['K2Tt']=self._NFD['K2T']
        
        # Reset
        self._demandout={}
        self._demandin=0
    
    def gendemand(self,OD,dt):       
        dK=0
        
        t=self._t[-1]
        
        for dest in OD.keys():
            n=OD[dest]*sum(self.demandpattern[t:t+dt])
            dK+=n
            
            
            #vs=VehicleSet(t,self.zid,dest,n)
            #vs.setroute(self.routes[dest])
            #vs.x=self._intdistmatrix[self.zid,vs.coming[0]]
            
            #self._queue.append(vs)
            
            for route in self.routes[dest].values():
                
                nn=route['perc']*n
                
                if nn>0.01:
                    vs=VehicleSet(t,self.zid,dest,nn)
                    vs.setroute(route['path'])
                    vs.x=self._intdistmatrix[self.zid,vs.coming[0]]

                    self._queue.append(vs)
                    
                    self._K_t[-1]+=nn
                    self._Kcum_t[-1]+=nn
                
    def receive(self,vs):
        newvs=VehicleSet(vs.gtime,vs.orig,vs.dest,vs.n)
        newvs.past=vs.past
        newvs.now=vs.now
        newvs.coming=vs.coming
       
        newvs.movenext()
        if len(newvs.coming) > 0:
            newvs.x=self._intdistmatrix[newvs.past[-1],newvs.coming[0]]
        else:
            newvs.x=self._intdistmatrix[newvs.past[-1],newvs.now]
            
        self._queue.append(newvs)
        self._K_t[-1]+=newvs.n
        self._inflow_t[-1]+=newvs.n
        
    def drive(self,dt):
        t=self._t[-1]
        
        VT=self.getThroughSpeed()
        VL=self.getLocalSpeed()
        
        self._VT_t.append(VT)
        self._VL_t.append(VL)
        
        remove=[]
        
        for i in range(len(self._queue)):
            if len(self._queue[i].past)==0 and self._queue[i].coming[-1]==self.zid:
                V=VL
            elif len(self._queue[i].past)==0 or self._queue[i].coming[-1]==self.zid: #If first zone or last zone
                V=.5*(VL+VT)  
            else:
                V=VT
            
            self._V.append(V)
            
            dx=V/3600*dt
 
            self._dcum_t[-1]+=min(self._queue[i].x,dx)*self._queue[i].n
            self._queue[i].x=max(0,self._queue[i].x-dx)
            
            
            if self._queue[i].x==0:
                if self._queue[i].coming[0]==self.zid:
                    self._queue[i].ftime=t
                    self._finished.append(self._queue[i])
                    self._K_t[-1]-=self._queue[i].n
                else:
                    self._pending.append(self._queue[i])
                remove.append(i)
        
        remove.sort(reverse=True)
        for i in remove:
            del self._queue[i]
    
    
    def updatedemandout(self,key,val):
        self._demandout_t[-1]+=val
        try:
            self._demandout[key]+=val
        except:
            self._demandout[key]=val  
    
    def reducedemandout(self,key,factor):
        self._demandout[key]*=factor
        
    def updatedemandin(self,val):
        self._demandin+=val
    
    def updateoutflow(self):
        self._outflow_t[-1]=sum(self._demandout.values())
    
    def getSupply(self):
        try:
            K=self._K_t[-1]/self._NFD['Lnetwork']
            
            P3=max((K-self._NFD['Kj'])*self._NFD['w'],self._NFD['Pmin']) #Production according to congested branch
            R=min(P3,self._NFD['Pmax'])*self._NFD['Lnetwork']/self._NFD['Ltrip']
        except:
            R=self._NFD['Pmax']*self._NFD['Lnetwork']/self._NFD['Ltrip']
        
        return R 

    def getLocalSpeed(self):
        try:
            K=self._K_t[-1]/self._NFD['Lnetwork']
        except:
            K=0
        
        if K==0:
            R=self._NFD['vL'] # With zero accumulation speed is free flow speed and flow is zero
        else:
            P1=K*self._NFD['vL'] #Production according to free flow branch
            
            if self._NFD['K1L'] == self._NFD['K2L']:
                P2=self._NFD['CL']
            else:
                P2=(K-self._NFD['K1L'])/(self._NFD['K2L']-self._NFD['K1L'])*self._NFD['CL']+(self._NFD['K2L']-K)/(self._NFD['K2L']-self._NFD['K1L'])*self._NFD['K1L']*self._NFD['vL']
            
            P3=max((K-self._NFD['KjL'])*self._NFD['wL'],self._NFD['PminL']) #Production according to congested branch

            P=min(P1,P2,P3,self._NFD['CL'])
            V=P/K
            
            R=V
        
        return R
    
    def getThroughSpeed(self):     
        try:
            K=self._K_t[-1]/self._NFD['Lnetwork']
        except:
            K=0
        
        if K==0:
            R=self._NFD['vT'] # With zero accumulation speed is free flow speed and flow is zero
        else:
            P1=K*self._NFD['vT'] #Production according to free flow branch
            
            if self._NFD['K1Tt'] == self._NFD['K2Tt']:
                P2=self._NFD['CTt']
            else:
                P2=(K-self._NFD['K1Tt'])/(self._NFD['K2Tt']-self._NFD['K1Tt'])*self._NFD['CTt']+(self._NFD['K2Tt']-K)/(self._NFD['K2Tt']-self._NFD['K1Tt'])*self._NFD['K1Tt']*self._NFD['vT']
            
            P3=max((K-self._NFD['KjT'])*self._NFD['wT'],self._NFD['PminT']) #Production according to congested branch

            P=min(P1,P2,P3,self._NFD['CTt'])
            V=P/K
            
            R=V
        
        return R
    
    def __repr__(self):
        return 'Zone: '+str(self.zid)