
exec(open('vehicleset.py').read())

class Simulation:
        
    def __init__(self):
        self.zones=None
        self._odmatrix={}
        self._routes={}
        self.dt=60
        self.tmax=24*3600
        self.routing=0
        self.logitp=0.25
        self.routep=.1
        self.supplyrestriction=False
        self.minxmin=100
        
    def run(self):
        ## ##
        for t in range(0,self.tmax,self.dt):            
            ### UPDATE ROUTE DURATION ###
            for pair in self._routes.keys():
                if pair[0]==pair[1]:
                    self.zones[pair[0]].routes[pair[1]]={0:{'path':self._routes[pair],'perc':1}}
                    continue
                 
                if self.routing == 1: #Logit             
                    self.zones[pair[0]].routes[pair[1]]={}

                    ttexp=0
                    for key,path in enumerate(self._routes[pair]): 
                        tt=0
                        tt+=self.zones[path[0]]._intdistmatrix[path[0],path[1]]/self.zones[path[0]].getLocalSpeed()

                        for i in range(1,len(path)-1): 
                            tt+=self.zones[path[i]]._intdistmatrix[path[i-1],path[i+1]]/self.zones[path[i]].getThroughSpeed()
                        
                        if len(path)>2:
                            tt+=self.zones[path[-1]]._intdistmatrix[path[-2],path[-1]]/self.zones[path[-1]].getLocalSpeed()

                        ttexp+=2.718**(-self.logitp*tt)

                        self.zones[pair[0]].routes[pair[1]][key]={'path':path,'tt':tt}
                    
                    ptot=0
                    for key in self.zones[pair[0]].routes[pair[1]].keys():
                        p=2.718**(-self.logitp*self.zones[pair[0]].routes[pair[1]][key]['tt'])/ttexp
                        ptot+=p
                        self.zones[pair[0]].routes[pair[1]][key]['perc']=p
                    
                    if not round(ptot,1)==1.0:
                        raise Exception(ptot,pair,self.zones[pair[0]].routes[pair[1]].values(),self._routes[pair],ttexp)
                        
                elif self.routing == 2: #                   
                    routeset={}
                    ttmin=1e99
                    for key,path in enumerate(self._routes[pair]): 
                        tt=0
                        tt+=self.zones[path[0]]._intdistmatrix[path[0],path[1]]/self.zones[path[0]].getLocalSpeed()

                        for i in range(1,len(path)-1): 
                            tt+=self.zones[path[i]]._intdistmatrix[path[i-1],path[i+1]]/self.zones[path[i]].getThroughSpeed()
                        
                        if len(path)>2:
                            tt+=self.zones[path[-1]]._intdistmatrix[path[-2],path[-1]]/self.zones[path[-1]].getLocalSpeed()
                            
                        routeset[key]={'path':path,'tt':tt}
                        
                        if tt<ttmin:
                            ttmin=tt

                    for key in routeset.keys(): 
                        routeset[key]['perc']=routeset[key]['tt']==ttmin
                            
                    try:
                        for key in self.zones[pair[0]].routes[pair[1]].keys(): 
                            self.zones[pair[0]].routes[pair[1]][key]['perc']*=(1-self.routep)
                            self.zones[pair[0]].routes[pair[1]][key]['perc']+=routeset[key]['perc']*self.routep
                    
                    except:
                        self.zones[pair[0]].routes[pair[1]]=routeset
                        
                        
                else: #All-or-nothing
                    ttmin=1e99
                    for path in self._routes[pair]:   
                        tt=0
                        tt+=self.zones[path[0]]._intdistmatrix[path[0],path[1]]/self.zones[path[0]].getLocalSpeed()

                        for i in range(1,len(path)-1): 
                            tt+=self.zones[path[i]]._intdistmatrix[path[i-1],path[i+1]]/self.zones[path[i]].getThroughSpeed()
                        
                        if len(path)>2:
                            tt+=self.zones[path[-1]]._intdistmatrix[path[-2],path[-1]]/self.zones[path[-1]].getLocalSpeed()
                            
                        if tt<ttmin:
                            ttmin=tt
                            self.zones[pair[0]].routes[pair[1]]={0:{'path':path,'perc':1}}
                    
            ### FIRST STEP ###       
            for zid in self.zones.members.keys():
                ## Update system state variables ##
                self.zones[zid].nextstep(self.dt)
                
                ## Generate new vehicles ##
                self.zones[zid].gendemand(self._odmatrix[zid],self.dt)
                
                ## Update distances covered by each vehicle ##
                self.zones[zid].drive(self.dt)
                
                ## Determine the outbound & inbound demand ## 
                
                #Determine the unrestricted demand
                for i in range(len(self.zones[zid]._pending)): #Loop through vehicles in pending
                    vs=self.zones[zid]._pending[i]
                    
                    key=(vs.coming[0],vs.coming[-1])
                    val=vs.n
                    
                    #Update the outbound demand
                    self.zones[zid].updatedemandout(key,val)
                    
                #Determine reductionfactor for boundary capacity restrictions
                reductionfactor={}
                
                for nid in self.zones[zid]._neighbours: #Loop through neighbours
                    totaldemand=sum([val for key,val in self.zones[zid]._demandout.items() if key[0]==nid])
                    if totaldemand > 0 :
                        reductionfactor[nid]=min(self.zones[zid]._boundcap[nid]/totaldemand,1)

                for key in self.zones[zid]._demandout.keys():
                    #Reduce the outbound demand
                    self.zones[zid].reducedemandout(key,reductionfactor[key[0]])
                    
                    #Update the inbound demand
                    self.zones[key[0]].updatedemandin(self.zones[zid]._demandout[key])
            
            ### SECOND STEP ###
            x={} #Reduction factor if supply is not sufficient
            for zid in self.zones.members.keys():              
                d=self.zones[zid]._demandin
                
                if d>0 and self.supplyrestriction:
                    #Determine supply of zid
                    s=self.zones[zid].getSupply()*self.dt/3600 

                    #Save reduction factor: supply/demand
                    x[zid]=min(s/d,1)
                    
                    self.minxmin=min(self.minxmin,s/d)
                else:
                    #No restrictions
                    x[zid]=1
            
            ### THIRD STEP ###
            for zid in self.zones.members.keys():
                
                ## Reduce demand if supply is insufficient ##
                y=set([key[0] for key in self.zones[zid]._demandout.keys()]) #All zones with demand from zid
                
                xmin=1 #Smallest reduction factor
    
                for nid in self.zones[zid]._neighbours: #For each neighbour of zid
                    if x[nid]<xmin and nid in y: #If demand from zid to nid and reduction factor is smaller
                        #Update smallest reduction factor
                        xmin=x[nid] 
                
                
                for key in self.zones[zid]._demandout.keys():
                    #Reduce demand with reduction factor based on supply
                    self.zones[zid].reducedemandout(key,xmin)
                    #self.zones[zid]._demandout[key]=self.zones[zid]._demandout[key]*xmin
                
                self.zones[zid].updateoutflow()
                
                ## Move vehicles between zones ##
                
                remove=[] #List with vehicles to be removed from pending
                
                #Loop through all vehiclesets that want to leave zid
                for i in range(len(self.zones[zid]._pending)): 
                    
                    #Next zone & final dest
                    c=self.zones[zid]._pending[i].coming[0],self.zones[zid]._pending[i].coming[-1] 
                    
                    #If demand from zid to c[0] with final dest c[1]
                    if c in self.zones[zid]._demandout.keys(): 
                        
                        # If remaining demand is > 0
                        if self.zones[zid]._demandout[c] > 0: 
                            
                            #If vehicleset larger than remaing demand
                            if self.zones[zid]._pending[i].n > self.zones[zid]._demandout[c]: 
                                #Reduce accumulation by the remaining demand
                                self.zones[zid]._K_t[-1]-=self.zones[zid]._demandout[c] 
                                
                                #Difference between vehicleset size and demand
                                diff=self.zones[zid]._pending[i].n-self.zones[zid]._demandout[c] 
                                
                                #Update the vehicleset size
                                self.zones[zid]._pending[i].n=self.zones[zid]._demandout[c] 
                                
                                #Send the vehicle to the next zone
                                self.zones[c[0]].receive(self.zones[zid]._pending[i]) 

                                #Update vehicleset size again
                                self.zones[zid]._pending[i].n=diff 
                                
                                #Remaining demand is zero
                                self.zones[zid]._demandout[c]=0 

                            else: #Vehicleset smaller than remaining demand
                                #Reduce accumulation
                                self.zones[zid]._K_t[-1]-=self.zones[zid]._pending[i].n
                                
                                #Reduce remaining outbound demand
                                self.zones[zid]._demandout[c]-=self.zones[zid]._pending[i].n 
                                
                                #Send the vehicle to the next zone
                                self.zones[c[0]].receive(self.zones[zid]._pending[i]) 
                                
                                #Remove this vehicleset from pending
                                remove.append(i) 
                
                # Delete the vehicles from pending
                remove.sort(reverse=True) #Reverse sorting, to keep index i correct
                for i in remove:
                    del self.zones[zid]._pending[i]              
                                       
    def setRoutes(self,routes):
        if not (len(routes.keys()) == len(self.zones.members)**2): raise Exception("Invalid dimensions for routeset",len(self.zones.members),len(routes.keys()))

        self._routes=routes
    
    def setODmatrix(self,matrix):
        if not (len(matrix) == len(self.zones.members)**2): raise Exception("Invalid dimensions for O&D-matrix")
        
        self._odmatrix={}
        
        for i in self.zones.members.keys():
            self._odmatrix[i]={j:matrix[i,j] for j in self.zones.members.keys()} 
    
    def __repr__(self):
        return 'Simulation'