def K2PV(K,NFD,mode=0):
    if K==0:
        return 0,NFD['vf'] # With zero accumulation speed is free flow speed and flow is zero
    else:
        Pmax=NFD['K1']*NFD['vf'] #Capacity
        w=-Pmax/(NFD['Kj']-NFD['K2']) #Jam wave speed

        Pmin=0.05*Pmax #To prevent gridlock set a minimum production

        P1=K*NFD['vf'] #Production according to free flow branch
        P2=max((K-NFD['Kj'])*w,Pmin) #Production according to congested branch

        if mode==1: #Demand
            P=min(P1,Pmax)
        elif mode==2: #Supply
            P=min(P2,Pmax)
        else: #NFD
            P=min(min(P1,P2),Pmax)

        V=P/K

        return P,V
        
        